/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.util.SoundEvent;

public final class SoundTypeUtils {
    private static final Reference2ObjectOpenHashMap<SoundType, String> soundTypeMap = new Reference2ObjectOpenHashMap();
    private static final Map<String, SoundType> soundTypeMapInv = new TreeMap<String, SoundType>(String.CASE_INSENSITIVE_ORDER);

    private SoundTypeUtils() {
    }

    public static void forEach(@Nonnull Consumer<SoundType> consumer) {
        for (SoundType type : soundTypeMap.keySet()) {
            consumer.accept(type);
        }
    }

    @Nullable
    public static SoundType getSoundType(@Nonnull String name) {
        return soundTypeMapInv.get(name);
    }

    @Nullable
    public static String getSoundTypeName(@Nonnull SoundType st) {
        return (String)soundTypeMap.get((Object)st);
    }

    public static boolean isStepSoundValid(@Nullable SoundType st) {
        return st != null && SoundTypeUtils.isValid(st.func_185844_d());
    }

    public static boolean isValid(@Nonnull SoundEvent se) {
        return se != null && se.func_187503_a() != null;
    }

    static {
        soundTypeMap.defaultReturnValue((Object)"CUSTOM");
        soundTypeMap.put((Object)SoundType.field_185848_a, (Object)"WOOD");
        soundTypeMap.put((Object)SoundType.field_185849_b, (Object)"GROUND");
        soundTypeMap.put((Object)SoundType.field_185850_c, (Object)"PLANT");
        soundTypeMap.put((Object)SoundType.field_235600_d_, (Object)"LILY_PADS");
        soundTypeMap.put((Object)SoundType.field_185851_d, (Object)"STONE");
        soundTypeMap.put((Object)SoundType.field_185852_e, (Object)"METAL");
        soundTypeMap.put((Object)SoundType.field_185853_f, (Object)"GLASS");
        soundTypeMap.put((Object)SoundType.field_185854_g, (Object)"CLOTH");
        soundTypeMap.put((Object)SoundType.field_185855_h, (Object)"SAND");
        soundTypeMap.put((Object)SoundType.field_185856_i, (Object)"SNOW");
        soundTypeMap.put((Object)SoundType.field_185857_j, (Object)"LADDER");
        soundTypeMap.put((Object)SoundType.field_185858_k, (Object)"ANVIL");
        soundTypeMap.put((Object)SoundType.field_185859_l, (Object)"SLIME");
        soundTypeMap.put((Object)SoundType.field_226947_m_, (Object)"HONEY");
        soundTypeMap.put((Object)SoundType.field_211382_m, (Object)"WET_GRASS");
        soundTypeMap.put((Object)SoundType.field_211383_n, (Object)"CORAL");
        soundTypeMap.put((Object)SoundType.field_222468_o, (Object)"BAMBOO");
        soundTypeMap.put((Object)SoundType.field_222469_p, (Object)"BAMBOO_SAPLING");
        soundTypeMap.put((Object)SoundType.field_222470_q, (Object)"SCAFFOLDING");
        soundTypeMap.put((Object)SoundType.field_222471_r, (Object)"SWEET_BERRY_BUSH");
        soundTypeMap.put((Object)SoundType.field_222472_s, (Object)"CROP");
        soundTypeMap.put((Object)SoundType.field_222473_t, (Object)"STEM");
        soundTypeMap.put((Object)SoundType.field_235601_w_, (Object)"VINE");
        soundTypeMap.put((Object)SoundType.field_222474_u, (Object)"NETHER_WART");
        soundTypeMap.put((Object)SoundType.field_222475_v, (Object)"LANTERN");
        soundTypeMap.put((Object)SoundType.field_235602_z_, (Object)"HYPHAE");
        soundTypeMap.put((Object)SoundType.field_235579_A_, (Object)"NYLIUM");
        soundTypeMap.put((Object)SoundType.field_235580_B_, (Object)"FUNGUS");
        soundTypeMap.put((Object)SoundType.field_235581_C_, (Object)"ROOT");
        soundTypeMap.put((Object)SoundType.field_235582_D_, (Object)"SHROOMLIGHT");
        soundTypeMap.put((Object)SoundType.field_235583_E_, (Object)"NETHER_VINE");
        soundTypeMap.put((Object)SoundType.field_235584_F_, (Object)"NETHER_VINE_LOWER_PITCH");
        soundTypeMap.put((Object)SoundType.field_235585_G_, (Object)"SOUL_SAND");
        soundTypeMap.put((Object)SoundType.field_235586_H_, (Object)"SOUL_SOIL");
        soundTypeMap.put((Object)SoundType.field_235587_I_, (Object)"BASALT");
        soundTypeMap.put((Object)SoundType.field_235588_J_, (Object)"WART");
        soundTypeMap.put((Object)SoundType.field_235589_K_, (Object)"NETHERRACK");
        soundTypeMap.put((Object)SoundType.field_235590_L_, (Object)"NETHER_BRICK");
        soundTypeMap.put((Object)SoundType.field_235591_M_, (Object)"NETHER_SPROUT");
        soundTypeMap.put((Object)SoundType.field_235592_N_, (Object)"NETHER_ORE");
        soundTypeMap.put((Object)SoundType.field_235593_O_, (Object)"BONE");
        soundTypeMap.put((Object)SoundType.field_235594_P_, (Object)"NETHERITE");
        soundTypeMap.put((Object)SoundType.field_235595_Q_, (Object)"ANCIENT_DEBRIS");
        soundTypeMap.put((Object)SoundType.field_235596_R_, (Object)"LODESTONE");
        soundTypeMap.put((Object)SoundType.field_235597_S_, (Object)"CHAIN");
        soundTypeMap.put((Object)SoundType.field_235598_T_, (Object)"NETHER_GOLD");
        soundTypeMap.put((Object)SoundType.field_235599_U_, (Object)"GILDED_BLACKSTONE");
        for (Map.Entry kvp : soundTypeMap.entrySet()) {
            soundTypeMapInv.put((String)kvp.getValue(), (SoundType)kvp.getKey());
        }
    }
}

